using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsDotNet4
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            m_actualLanguage = 0;

            basePathTextBox.Text = Properties.Settings.Default.DS7000AxPath;
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            this.userControl11.setPage(numericUpDown1.Value);
            m_actualPage = numericUpDown1.Value;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.userControl11.setLanguage(comboBox1.SelectedIndex);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            m_actualLanguage = comboBox1.SelectedIndex;
            m_actualPage = numericUpDown1.Value;
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            OnResize();
        }

        
        private void OnResize()
        {
        }

  
        private void btnStartActiveX_Click(object sender, EventArgs e)
        {

            if (btnStartActiveX.Text == "Enable ActiveX")
            {
                // settings which must be set before ActiveX control was enabled
                //userControl11.UsccPath = Properties.Settings.Default.DS7000AxPath;

                // enable ActiveX control
                this.userControl11.EnableActiveX(1);

                btnStartActiveX.Text = "Disable ActiveX";
                preInitSettingsGroupBox.Hide();

                // interact with the ActiveX control
                int apiVersion = userControl11.ApiVersion;
                string version = userControl11.Version;

                this.lblApiVersion.Text = string.Format("{0:d}", apiVersion);
                this.lblVersion.Text = version;                                                                                                                         
                this.lblBuildDate.Text = userControl11.BuildDate;
                this.lblBuildNumber.Text = string.Format("{0:d}", userControl11.BuildNumber);
                userControl11.setLanguage(m_actualLanguage);
                userControl11.setPage(m_actualPage);
            }
            else
            {
                this.userControl11.EnableActiveX(0);

                btnStartActiveX.Text = "Enable ActiveX";
                preInitSettingsGroupBox.Show();
            }


        }

        private void userControl11_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.L && (e.Control))
            {
                toggleLanguage();
            }
            if (e.KeyCode == Keys.R && (e.Control))
            {
                handleRights();
            }
        }

        private void toggleLanguage()
        {
            m_actualLanguage = (m_actualLanguage == 0) ? 1 : 0;
            userControl11.setLanguage(m_actualLanguage);
        }

        private void handleRights()
        {
            // throw new Exception("The method or operation is not implemented.");
        }

        private void dS7000AXPfadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1 = new System.Windows.Forms.FolderBrowserDialog();
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                string folderName = folderBrowserDialog1.SelectedPath;
                Properties.Settings.Default.DS7000AxPath = folderName;
                Properties.Settings.Default.Save();
                userControl11.UsccPath = folderName;
            }
        }

        private int m_actualLanguage;
        private FolderBrowserDialog folderBrowserDialog1;
        private decimal m_actualPage;

        private void button1_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1 = new System.Windows.Forms.FolderBrowserDialog();
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                string folderName = folderBrowserDialog1.SelectedPath;
                userControl11.UsccPath = folderName;
                basePathTextBox.Text = folderName;
            }
        }

        private void btnSetAppScope_Click(object sender, EventArgs e)
        {
            AppScopeDlg dlg = new AppScopeDlg();
            DialogResult res = dlg.ShowDialog();
            if (res == DialogResult.OK)
            {
                userControl11.ApplicationScope = dlg.AppScope;
                scopeTextBox.Text = dlg.AppScope;
            }
        }
        

    }
}
